#!/usr/bin/env python3
import sys, json, datetime

header = '''# This file was autogenerated at {0}.
# Do not change it, see source json bsp file and 'tools/json2py.py'
import bsp

__bsp = {1}
__cfg = None

def get_config():
    global __cfg
    if __cfg is None:
        __cfg = bsp.gen_bsp(__bsp)
    return __cfg

def __getattr__(name):
    cfg = get_config()
    if name in cfg:
        return cfg[name]
    raise AttributeError()

'''

class JSONWithCommentsDecoder(json.JSONDecoder):
    def __init__(self, **kw):
        super().__init__(**kw)

    def decode(self, s: str):
        s = '\n'.join(l for l in s.split('\n') if not l.lstrip(' ').startswith('//'))
        return super().decode(s)

if __name__ == '__main__':
    print( header.format(datetime.datetime.now(), json.loads(sys.stdin.read(), cls=JSONWithCommentsDecoder)))